//=============================================================================

#ifndef MOVE_H
#define MOVE_H

#include <iostream>

//-----------------------------------------------------------------------------

enum class color { white, black };
std::ostream& operator<<(std::ostream& out, color c);

//-----------------------------------------------------------------------------

class move
{
public:
   move(int x, int y, color c) : x_(x), y_(y), color_(c) {}
   move(int f, color c) : x_(f/3), y_(f%3), color_(c) {}

   int x() const { return x_; }
   int y() const { return y_; }

   color get_color() const { return color_; }

   friend std::ostream& operator<<(std::ostream& out, const move& m);

private:
   int x_;
   int y_;
   color color_;
};

//-----------------------------------------------------------------------------

#endif
