//=============================================================================

#include <iostream>
#include <ostream>
using namespace std;

//-----------------------------------------------------------------------------

class rational
{
public:
   rational(int n = 0, int d = 1) : numerator_(n), denominator_(d) {}

   rational& operator*=(const rational& f);

   friend rational operator*(const rational& lhs, const rational& rhs);
   friend ostream& operator<<(ostream& out, const rational& r);

private:
   int numerator_, denominator_;
};

//-----------------------------------------------------------------------------

rational& rational::operator*=(const rational& r)
{
   numerator_ *= r.numerator_;
   denominator_ *= r.denominator_;
   return *this;
}

//-----------------------------------------------------------------------------

rational operator*(const rational& lhs, const rational& rhs)
{
   return rational(lhs.numerator_ * rhs.numerator_, lhs.denominator_ * rhs.denominator_);
}

//-----------------------------------------------------------------------------

ostream& operator<<(ostream& out, const rational& r)
{
   out << r.numerator_;
   if (r.denominator_ != 1)
   {
      out << '/' << r.denominator_;
   }
   return out;
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_16_01_Bruch_Klasse\n\n";

   rational r, r1(2, 3), r2(4, 5);
   cout << "r:  " << r << '\n';
   cout << "r1: " << r1 << '\n';
   cout << "r2: " << r2 << "\n\n";

   r = r1 * r2;
   cout << r1 << " * " << r2 << "  =>  r: " << r << '\n';

   r = operator*(r1, r2);
   cout << r1 << " * " << r2 << "  =>  r: " << r << '\n';

   r = r1 * 6;
   cout << r1 << " * 6    =>  r: " << r << '\n';

   r = 4 * r2;
   cout << "4   * " << r2 << "  =>  r: " << r << "\n\n";

   r = r1 *= r2;
   cout << "r = r1 *= " << r2 << " => r: " << r << " und r1: " << r1 << "\n\n";

   r2 *= 3;
   cout << "r2 *= 3   => " << r2 << '\n';
}
