//=============================================================================

#ifndef BOARD_H
#define BOARD_H

#include <array>
#include "move.h"

//-----------------------------------------------------------------------------

class board
{
public:
   board();

   bool valid(const move& m) const { return field_[m.x()][m.y()] == state::empty; }

   void set(const move& m) { field_[m.x()][m.y()] = convert(m.get_color()); }

   bool full() const;
   bool wins(color) const;

   void print() const;

private:
   enum class state { white = static_cast<int>(color::white), black = static_cast<int>(color::black), empty };

   static state convert(color c) { return static_cast<state>(c); }

   using line = std::array<state, 3>;
   using field = std::array<line, 3>;
   field field_;
};

//-----------------------------------------------------------------------------

#endif
