//=============================================================================

#include <iomanip>
#include <iostream>
#include "village.h"
using namespace std;

//-----------------------------------------------------------------------------

random_device village::rd;

//-----------------------------------------------------------------------------

village::village(int count)
 : engine(rd()), dist(0, count-1),
   width_(static_cast<int>(log10(static_cast<double>(count))) + 1),
   persons_(count)
{
   persons_[0].set_telling();
}

//-----------------------------------------------------------------------------

bool village::next()
{
   int rnd1 = dist(engine);
   int rnd2 = dist(engine);
   while (rnd1 == rnd2)
   {
      rnd2 = dist(engine);
   }
   return person::meet(persons_[rnd1], persons_[rnd2]);
}

//-----------------------------------------------------------------------------

bool village::stable_state() const
{
   for (const person& p : persons_)
   {
      if (p.is_telling())
      {
         return false;
      }
   }
   return true;
}

//-----------------------------------------------------------------------------

void village::print() const
{
   int unknowing_count = 0, telling_count = 0, closemouthed_count = 0;
   for (const person& p : persons_)
   {
      if (p.is_unknowing()) ++unknowing_count;
      if (p.is_telling()) ++telling_count;
      if (p.is_closemouthed()) ++closemouthed_count;
   }

   cout << "U(" << setw(width_) << unknowing_count
      << ") E(" << setw(width_) << telling_count
      << ") S(" << setw(width_) << closemouthed_count
      << ") ";

   for (const person& p : persons_)
   {
      p.print();
   }
}
