//=============================================================================

#ifndef PERSON_H
#define PERSON_H

//-----------------------------------------------------------------------------

class person
{
public:
   person() : state_(state::unknowing) {}

   void set_telling() { state_ = state::telling; }

   bool is_unknowing() const { return state_ == state::unknowing; }
   bool is_telling() const { return state_ == state::telling; }
   bool is_closemouthed() const { return state_ == state::closemouthed; }

   static bool meet(person&, person&);

   void print() const;

private:
   enum class state { unknowing, telling, closemouthed };
   state state_;
};

//-----------------------------------------------------------------------------

#endif
