//=============================================================================

#include <cstdlib>
#include <iostream>
using namespace std;

//-----------------------------------------------------------------------------

class ring_counter
{
public:
   ring_counter(int end) : ring_counter(0, end, end < 0 ? -1 : 1) {}
   ring_counter(int begin, int end, int delta = 1);

   int next();

   int value() const { return value_; }

private:
   const int begin_;
   const int end_;
   const int delta_;
   int value_;
};

//-------------------------------------------------------------------------------

ring_counter::ring_counter(int begin, int end, int delta)
 : begin_(begin), end_(end), delta_(delta),
   value_(begin)
{
   if ((begin_ < end_ && delta_ <= 0) || (begin_ > end_ && delta_ >= 0))
   {
      cout << "Die Werte " << begin_ << ", " << end_ << ", " << delta_
         << " erzeugen einen Endlos Ring-Counter\n";
      exit(1);
   }
}

//-------------------------------------------------------------------------------

int ring_counter::next()
{
   value_ += delta_;
   if ((delta_ < 0 && value_ < end_) || (delta_ > 0 && value_ > end_))
   {
      value_ = begin_;
   }
   return value_;
}

//-------------------------------------------------------------------------------

int main()
{
   cout << "Aufg_14_02_Ringzaehler\n\n";

   cout << "Ring-Counter(5)\n-> ";
   ring_counter rc1(5);
   for (int i = 0; i < 20; ++i) cout << rc1.next() << ' ';
   cout << "\n\n";

   cout << "Ring-Counter(-3)\n-> ";
   ring_counter rc2(-3);
   for (int i = 0; i < 20; ++i) cout << rc2.next() << ' ';
   cout << "\n\n";

   cout << "Ring-Counter(-3, 5)\n-> ";
   ring_counter rc3(-3, 5);
   for (int i = 0; i < 20; ++i) cout << rc3.next() << ' ';
   cout << "\n\n";

   cout << "Ring-Counter(-10, 8, 5)\n-> ";
   ring_counter rc4(-10, 8, 5);
   for (int i = 0; i < 20; ++i) cout << rc4.next() << ' ';
   cout << "\n\n";

   cout << "Ring-Counter(30, 5, -7)\n-> ";
   ring_counter rc5(30, 5, -7);
   for (int i = 0; i < 20; ++i) cout << rc5.next() << ' ';
   cout << "\n\n";

   cout << "Ring-Counter(2, 50, -7)\n-> ";
   ring_counter rc6(2, 50, -7);
}
