//=============================================================================

#include <iostream>
#include <limits>
#include <random>
using namespace std;

//-----------------------------------------------------------------------------

constexpr int min_value =  1;
constexpr int max_value = 99;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_13_08_Zahlenspiel_2\n\n";

   random_device rd;
   mt19937 engine(rd());
   uniform_int_distribution<> dist(min_value, max_value);

   const int value = dist(engine);

   for (;;)
   {
      cout << "Bitte geben Sie eine Zahl ein: ";
      int input;
      cin >> input;
      if (cin.fail() || input < min_value || input > max_value)
      {
         cout << "Fehlerhafte Eingabe - bitte nochmal\n\n";
         cin.clear();
         cin.ignore(numeric_limits<streamsize>::max(), '\n');
         continue;
      }

      if (input < value)
      {
         cout << "Ihre Zahl ist leider zu klein\n\n";
      }
      else if (input > value)
      {
         cout << "Ihre Zahl ist leider zu gross\n\n";
      } 
      else
      {
         cout << "Hervorragend - Sie haben die Zahl gefunden. Gratulation\n\n";
         break;
      }
   }
}
