//=============================================================================
// Muster-Loesung mit eigener Rekursion

#include <filesystem>
#include <iostream>
#include <string>
using namespace std;
using namespace std::filesystem;

//-----------------------------------------------------------------------------

unsigned long long calcFileSizesPath(const path& searchpath, const string& extension)
{
   unsigned long long res = 0;

   directory_iterator it(searchpath);
   directory_iterator eit;
   for (; it != eit; ++it)
   {
      const path& p = it->path();
      if (is_regular_file(p) && (extension.empty() || p.extension() == extension))
      {
         res += file_size(p);
      }
      else if (is_directory(p))
      {
         res += calcFileSizesPath(p, extension);
      }
   }
   return res;
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_13_03_Platten_Platz_V1\n\n";

   cout << "Platten-Platz Verbrauch\n\n";
   path searchpath;
   for (string input;;)
   {
      cout << "Geben Sie bitte das Verzeichnis ein: ";
      getline(cin, input);
      searchpath = input;
      if (exists(searchpath) && is_directory(searchpath))
      {
         break;
      }
      cout << '"' << input << "\" ist kein Verzeichnis\n\n";
   }

   string extension;
   cout << "Geben Sie bitte die Extension ein: ";
   getline(cin, extension);
   if (!extension.empty())
   {
      extension = '.' + extension;
   }

   unsigned long long res = calcFileSizesPath(searchpath, extension);
   cout << "\nGesamtverbrauch: " << res << " Bytes" << '\n';
}
