//=============================================================================

#include <iostream>
#include <string>
#include <tuple>
using namespace std;

//-----------------------------------------------------------------------------

bool readUserInput(string& input)
{
   cout << "Eingabe: ";
   getline(cin, input);

   // Fehlende Engabe
   if (input.empty())
   {
      cout << "\nFehlende Eingabe\n";
      return false;
   }

   // Fehlerhafte Engabe
   auto pos = input.find_first_not_of("0123456789abcdefghijklmnopqrstuvwxyz");
   if (pos != string::npos)
   {
      cout << "\nFehlerhafte Eingabe\n";
      return false;
   }

   return true;
}

//-----------------------------------------------------------------------------

tuple<string::size_type, string::size_type> countDigitsAndChars(const string& in)
{
   string::size_type digit_counter = 0;
   string::size_type char_counter = 0;
   for (char c : in)
   {
      if ('0' <= c && c <= '9')
      {
         ++digit_counter;
      }
      else
      {
         ++char_counter;
      }
   }
   return { digit_counter, char_counter };
}

//-----------------------------------------------------------------------------

bool existsSolutions(string::size_type digit_counter, string::size_type char_counter)
{
   const string::size_type counter_diff = char_counter < digit_counter ? digit_counter - char_counter : char_counter - digit_counter;
   if (counter_diff > 1)
   {
      cout << "\nEs ist keine Loesung moeglich\n";
      return false;
   }
   return true;
}

//-----------------------------------------------------------------------------

void calcSolution(const string& in, bool digit_solution)
{
   cout << "Loesung: ";

   string::size_type digit_idx = 0;
   string::size_type char_idx = 0;
   const string::size_type len = in.length();
   while (digit_idx < len || char_idx < len)
   {
      if (digit_solution && digit_idx < len)
      {
         char c = in[digit_idx];
         if ('0' <= c && c <= '9')
         {
            cout << c;
            digit_solution = false;
         }
         ++digit_idx;
      }
      else if (!digit_solution && char_idx < len)
      {
         char c = in[char_idx];
         if (!('0' <= c && c <= '9'))
         {
            cout << c;
            digit_solution = true;
         }
         ++char_idx;
      }
      else
      {
         ++digit_idx;
         ++char_idx;
      }
   }
   cout << '\n';
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_12_13_String_Anordnung_2\n\n";

   string input;
   bool ok = readUserInput(input);
   if (!ok) return 0;

   auto [digit_counter, char_counter] = countDigitsAndChars(input);

   if (!existsSolutions(digit_counter, char_counter)) return 0;

   // Loesung mit Ziffer am Anfang moeglich?
   if (digit_counter >= char_counter)
   {
      calcSolution(input, true);
   }

   // Loesung mit Buchstabe am Anfang moeglich?
   if (char_counter >= digit_counter)
   {
      calcSolution(input, false);
   }
}
