//=============================================================================

#include <iostream>
#include <string>
using namespace std;

//-----------------------------------------------------------------------------

string create_line(char c, string::size_type width, string::size_type pos)
{
   string line(width+1, ' ');
   line[pos] = c;
   line[width-pos-1] = c;
   line[width] = '\n';
   return line;
}

//-----------------------------------------------------------------------------

string create_diamond(char c)
{
   string::size_type count = c - 'A';
   string::size_type width = 2 * count + 1;

   string res;
   res.reserve((width + 1) * (2 * count + 1));
   string::size_type idx = count;
   char ch = 'A';
   for (; ch < c; ++ch)
   {
      res += create_line(ch, width, idx--);
   }
   res += create_line(ch--, width, idx);
   for (; ch >= 'A'; --ch)
   {
      res += create_line(ch, width, ++idx);
   }
   return res;
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_12_11_Diamant_Graph\n\n";

   cout << "Bitte geben Sie einen Buchstaben ein: ";
   char c;
   cin >> c;

   // Kleinbuchstaben in Grossbuchstaben wandeln
   // - Funktioniert mit allen ASCII basierten Zeichensaetzen
   // - Die Kleinbuchstaben liegen 32 ueber den Grossbuchstaben
   // - Alle anderen Eingaben werden auch irgendwie gewandelt, aber egal
   c &= (0b1 << 5) ^ -1;

   if ((c < 'A') || (c > 'Z'))
   {
      cout << "Fehlerhafte Eingabe\n";
      return 0;
   }

   string diamond = create_diamond(c);
   cout << diamond << '\n';
}
