//=============================================================================

#include <iostream>
using namespace std;

//-----------------------------------------------------------------------------

double const epsilon = 0.0001;

//-----------------------------------------------------------------------------

double square_root(double v, double lower_limit, double upper_limit)
{
   double average = (lower_limit + upper_limit) / 2;
   double av2 = average * average;
   if ((av2 - epsilon < v) && (av2 + epsilon > v))
   {
      return average;
   }
   if (v < av2)
   {
      return square_root(v, lower_limit, average);
   }
   return square_root(v, average, upper_limit);
}

//-----------------------------------------------------------------------------

double square_root(double v)
{
   return square_root(v, 1.0, v);
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_12_06_Quadratwurzel_2_V3\n\n";

   cout << "Rekursive Wurzel-Berechnung fuer Zahlen groesser-gleich 1.0\n";
   cout << "Zahl: ";

   double v;
   cin >> v;
   if (cin.fail() || v < 1.0)
   {
      cout << "Fehleingabe\n";
      return 0;
   }

   cout << "Berechne Wurzel aus " << v << " mit einem Epsilon von " << epsilon << '\n';
   cout << "Wurzel: " << square_root(v) << '\n';
}
