//=============================================================================
// Hinweis: Die Funktionen fuer die Zeitmessungen werden erst im Kapitel 13 eingefuehrt.

#include <chrono>
#include <iostream>
using namespace std;
using namespace std::chrono;

//-----------------------------------------------------------------------------

unsigned int mul(unsigned int v1, unsigned int v2)
{
   if (v1 == 1)
   {
      return v2;
   }
   return v2 + mul(v1 - 1, v2);
}

//-----------------------------------------------------------------------------

unsigned int mul_direct(unsigned int v1, unsigned int v2)
{
   return mul(v1, v2);
}

//-----------------------------------------------------------------------------

unsigned int mul_optimi(unsigned int v1, unsigned int v2)
{
   if (v1 > v2)
   {
      return mul(v2, v1);
   }
   return mul(v1, v2);
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_12_05_Rekursive_Multiplikation_V2\n\n";

   const unsigned int v1 = 4'000;
   const unsigned int v2 = 4;

   auto start = steady_clock::now();
   auto res = mul_direct(v1, v2);
   auto end = steady_clock::now();
   duration<double> elapsed_seconds = end - start;
   cout << "mul_direct(" << v1 << ", " << v2 << ") => " << res << " in " << elapsed_seconds.count() << " s\n";

   start = steady_clock::now();
   res = mul_direct(v2, v1);
   end = steady_clock::now();
   elapsed_seconds = end - start;
   cout << "mul_direct(" << v2 << ", " << v1 << ") => " << res << " in " << elapsed_seconds.count() << " s\n";

   start = steady_clock::now();
   res = mul_optimi(v1, v2);
   end = steady_clock::now();
   elapsed_seconds = end - start;
   cout << "mul_optimi(" << v1 << ", " << v2 << ") => " << res << " in " << elapsed_seconds.count() << " s\n";

   start = steady_clock::now();
   res = mul_optimi(v2, v1);
   end = steady_clock::now();
   elapsed_seconds = end - start;
   cout << "mul_optimi(" << v2 << ", " << v1 << ") => " << res << " in " << elapsed_seconds.count() << " s\n";
}
