//=============================================================================

#include <array>
#include <iostream>
using namespace std;

//-----------------------------------------------------------------------------

constexpr int limit = 100;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_10_06_Sieb_Eratosthenes\n\n";

   // Sieb anlegen
   array<int, limit> sieve;
   for (int i = 0; i < limit; ++i)
   {
      sieve[i] = i + 1;
   }

   // Alle Nicht-Primzahlen rauswerfen - auf '0' setzen
   // * Stoppen sollte man schon bei der Wurzel von 'limit'
   //   - Aber wir kennen die Wurzel-Funktion noch nicht - siehe Kapitel 13
   //   - Darum laufen wir viel zu weit bis 'limit'
   for (int i = 1; i < limit; ++i)
   {
      const int value = sieve[i];
      if (value == 0) continue;
      for (int j = 2* value; j <= limit; j += value)
      {
         sieve[j - 1] = 0;
      }
   }

   // Ausgabe
   for (int i : sieve)
   {
      if (i != 0)
      {
         cout << i << ' ';
      }
   }
   cout << '\n';
}
