//=============================================================================
// Natuerlich kann man mit Funktionen und Referenzen dieses Programm kleiner 
// und lesbarer gestalten - aber es geht auch so, mit den Mitteln die wir 
// bis Kapitel 9 schon kennen. Aufgabe 12.12 ist diese Aufgabe mit mehr Sprachfeatures.

#include <iostream>
#include <string>
using namespace std;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_09_06_String_Anordnung_1\n\n";

   cout << "Eingabe: ";
   string input;
   getline(cin, input);

   // Fehlende Engabe
   if (input.empty())
   {
      cout << "\nFehlende Eingabe\n";
      return 0;
   }

   // Fehlerhafte Engabe
   auto pos = input.find_first_not_of("0123456789abcdefghijklmnopqrstuvwxyz");
   if (pos != string::npos)
   {
      cout << "\nFehlerhafte Eingabe\n";
      return 0;
   }

   // Ziffern und Klein-Buchstaben zaehlen
   // => Um zu sehen, ob es keine, eine oder zwei Loesungen gibt
   string::size_type digit_counter = 0;
   string::size_type char_counter = 0;
   for (char c : input)
   {
      if ('0' <= c && c <= '9')
         ++digit_counter;
      else
         ++char_counter;
   }

   // Gibt es Loesungen?
   const string::size_type counter_diff = char_counter < digit_counter ? digit_counter - char_counter : char_counter - digit_counter;
   if (counter_diff > 1)
   {
      cout << "\nEs ist keine Loesung moeglich\n";
      return 0;
   }

   const string::size_type len = input.length();

   // Loesung mit Ziffer am Anfang moeglich?
   if (digit_counter >= char_counter)
   {
      cout << "Loesung: ";
      bool digit_turn = true;
      string::size_type digit_idx = 0;
      string::size_type char_idx = 0;
      while (digit_idx < len || char_idx < len)
      {
         if (digit_turn && digit_idx < len)
         {
            char c = input[digit_idx];
            if ('0' <= c && c <= '9')
            {
               cout << c;
               digit_turn = false;
            }
            ++digit_idx;
         }
         else if (char_idx < len)
         {
            char c = input[char_idx];
            if (!('0' <= c && c <= '9'))
            {
               cout << c;
               digit_turn = true;
            }
            ++char_idx;
         }
         else
         {
            ++digit_idx;
         }
      }
      cout << '\n';
   }

   // Loesung mit Buchstabe am Anfang moeglich?
   if (char_counter >= digit_counter)
   {
      cout << "Loesung: ";
      bool char_turn = true;
      string::size_type digit_idx = 0;
      string::size_type char_idx = 0;
      while (char_idx < len || digit_idx < len)
      {
         if (char_turn && char_idx < len)
         {
            char c = input[char_idx];
            if (!('0' <= c && c <= '9'))
            {
               cout << c;
               char_turn = false;
            }
            ++char_idx;
         }
         else if (digit_idx < len)
         {
            char c = input[digit_idx];
            if ('0' <= c && c <= '9')
            {
               cout << c;
               char_turn = true;
            }
            ++digit_idx;
         }
         else
         {
            ++char_idx;
         }
      }
      cout << '\n';
   }
}
