//=============================================================================

#include <iostream>
#include <iomanip>
using namespace std;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_08_04_Multiplikations_Matrix_2_V1\n\n";

   // 1-te Zahl einlesen
   int v1;
   cout << "Untere Grenze: ";
   cin >> v1;
   if (cin.fail() || v1 < 0)
   {
      cout << "Fehleingabe\n";
      return 0;
   }

   // 2-te Zahl einlesen
   int v2;
   cout << "Obere Grenze:  ";
   cin >> v2;
   if (cin.fail() || v2 < 0)
   {
      cout << "Fehleingabe\n";
      return 0;
   }

   // Zahlen sortieren, d.h. v1 <= v2
   if (v1 > v2)
   {
      int temp = v1;
      v1 = v2;
      v2 = temp;
   }

   // Nur Ausgaben bis zu einer 'ueberschaubaren Groesse' zulassen
   if (v2 - v1 > 10)
   {
      cout << "Zu grosse Matrix\n";
      return 0;
   }

   // Max. Ausgabe-Laenge berechnen:
   // Da wir noch nichts besseres kennen, via Schleife.
   // Bessere Alternativen waeren:
   // - Laenge via String-Wandlung 'ausprobieren'
   // - Log10 des maximalen Produkts nehmen
   int maxlen = 1;
   int product = v2 * v2;
   while ((product /= 10) > 0) ++maxlen;

   // Der Rest fast wir frueher, nur mit Breiten-Formatierung   
   cout << '\n' << setw(maxlen + 3) << '|';
   for (int i = v1; i <= v2; ++i)
   {
      cout << setw(maxlen + 2) << i;
   }
   cout << '\n';

   cout.fill('-');
   cout << setw(maxlen + 3) << '+';
   for (int i = v1; i <= v2; ++i)
   {
      cout << setw(maxlen + 2) << '-';
   }
   cout << "-\n";

   cout.fill(' ');
   for (int i = v1; i <= v2; ++i)
   {
      cout << setw(maxlen + 1) << i << " |";
      for (int j = v1; j <= v2; ++j)
      {
         cout << setw(maxlen + 2) << i * j;
      }
      cout << '\n';
   }
}
