#ifndef PLAYER_HPP
#define PLAYER_HPP

#include <memory>
#include <string>
#include "board.hpp"
#include "move.hpp"

class Player
{
public:
   Player(GameColor gameColor)
      : mGameColor(gameColor)
   {
   }

   virtual ~Player() = default;

   virtual std::string getName() const = 0;
   virtual Move askForMove(const Board& board) = 0;

protected:
   GameColor getGameColor() const { return mGameColor; }

private:
   GameColor mGameColor;
};

using PlayerPtr = std::unique_ptr<Player>;

#endif
