//=============================================================================

#include <iostream>
#include "board.hpp"
#include "computerfff.hpp"
#include "computerlff.hpp"
#include "computerrnd.hpp"
#include "human.hpp"
using namespace std;

//-----------------------------------------------------------------------------

enum class GameState
{
   Ongoing, End
};

//-----------------------------------------------------------------------------

GameState play(Player& player, Board& board)
{
   // 4. Spieler nach seinem Zug fragen
   Move move = player.askForMove(board);

   // 5. Zug durchfuehren (+ Ausgabe)
   cout << "\n" << player.getName() << " macht Zug: ";
   move.display(cout);
   cout << '\n';
   board.set(move);

   // 6. Spielfeld anzeigen
   board.display(cout);

   // 7. Pruefen ob Spieler gewonnen hat
   if (board.hasWin(move.getGameColor()))
   {
      cout << "\n" << player.getName() << " hat gewonnen\n";
      return GameState::End;
   }

   // 8. Pruefen ob unentschieden (Spielfeld voll) ist
   if (board.isFull())
   {
      cout << "\nRemis\n";
      return GameState::End;
   }

   return GameState::Ongoing;
}

//-----------------------------------------------------------------------------

PlayerPtr askUserForPlayer(GameColor gc)
{
   for (;;)
   {
      cout << "\nWaehlen Sie den Spielertyp:\n";
      cout << "- 1 = Mensch\n";
      cout << "- 2 = Computer FFF\n";
      cout << "- 3 = Computer LFF\n";
      cout << "- 4 = Computer Zufall\n\n";

      int choice;
      cin >> choice;
      if (cin.fail())
      {
         cin.clear(); // Fehlerstatus zuruecksetzen
         cin.ignore(numeric_limits<streamsize>::max(), '\n'); // Ungueltige Eingabe verwerfen
         cout << "\nUngueltige Eingabe. Bitte versuchen Sie es erneut.\n";
         continue;
      }

      switch (choice)
      {
      case 1:
         return make_unique<Human>(gc);
      case 2:
         return make_unique<ComputerFFF>(gc);
      case 3:
         return make_unique<ComputerLFF>(gc);
      case 4:
         return make_unique<ComputerRnd>(gc);
      }

      cout << "\nUngueltige Auswahl. Bitte versuchen Sie es erneut.\n";
   }
}

//-----------------------------------------------------------------------------
// Pseudo code / Algorithmus

int main()
{
   cout << "Uebung 10 - Tic-Tac-Toe 3 - mit Vererbung\n\n";

   // 1. Spielfeld initialisieren
   // - Fuer die erste Version haben wir keine Spielerklassen
   Board board;

   // 1.b Spieler-Objekte erstellen
   PlayerPtr player1 = askUserForPlayer(GameColor::White);
   PlayerPtr player2 = askUserForPlayer(GameColor::Black);

   // 2. Spielfeld anzeigen
   board.display(cout);

   // 3. Spielschleife
   for (;;)
   {
      if (play(*player1, board) == GameState::End) break;
      if (play(*player2, board) == GameState::End) break;
   }
}
