#include <iostream>
#include "human.hpp"
using namespace std;

Move Human::askForMove(const Board& board)
{  
   for (;;)
   {
      cout << "\nBitte geben Sie Ihren Zug ein (Feld 1..9): ";
      int no;
      cin >> no;

      if (cin.fail())
      {
         cin.clear(); // Fehlerstatus zuruecksetzen
         cin.ignore(numeric_limits<streamsize>::max(), '\n'); // Ungueltige Eingabe verwerfen
         cout << "Ungueltige Eingabe. Bitte versuchen Sie es erneut.\n";
         continue;
      }

      if (no < 1 || no > 9)
      {
         cout << "Ungueltige Feld-Eingabe. Bitte versuchen Sie es erneut.\n";
         continue;
      }

      // 0 :    0 / 3 = 0    0 % 3 = 0
      // 1 :    1 / 3 = 0    1 % 3 = 1
      // 2 :    2 / 3 = 0    2 % 3 = 2
      // 3 :    3 / 3 = 1    3 % 3 = 0
      // 4 :    4 / 3 = 1    4 % 3 = 1
      // ...
      // 8:     8 / 3 = 2    8 % 3 = 2

      const int row = (no - 1) / 3;
      const int col = (no - 1) % 3;

      if (board.isOccupied(row, col))
      {
         cout << "Das Feld ist bereits belegt. Bitte versuchen Sie es erneut.\n";
         continue;
      }

      return Move(row, col, getGameColor());
   }
}
