#include <random>
#include "computerrnd.hpp"
using namespace std;

Move ComputerRnd::askForMove(const Board& board)
{
   random_device rd;                           // Besser in das Objekt, oder sogar in die Klasse!
   mt19937 gen(rd());
   uniform_int_distribution<> dis(0, 2);
   for (;;)
   {
      const int row = dis(gen);
      const int col = dis(gen);
      if (!board.isOccupied(row, col))
      {
         return Move(row, col, getGameColor());
      }
   }
}
