#include <iostream>
#include "board.hpp"
using namespace std;

Board::Board()
{
   for (auto& row : mFields)
   {
      for (auto& field : row)
      {
         field = FieldState::Empty;
      }
   }
   //mFields[0][0] = FieldState::White;
   //mFields[0][0] = FieldState::Black;
}

void Board::display(ostream& out) const
{
   for (const auto& row : mFields)
   {
      for (const auto& field : row)
      {
         switch (field)
         {
            case FieldState::Empty:
               out << " _";
               break;
            case FieldState::White:
               out << " O";
               break;
            case FieldState::Black:
               out << " X";
               break;
         }
      }
      out << '\n';
   }
}

bool Board::isOccupied(int row, int col) const
{
   return mFields[row][col] != FieldState::Empty;
}

void Board::set(const Move& move)
{
   const int row = move.getRow();
   const int col = move.getCol();
   const GameColor gc = move.getGameColor();
   mFields[row][col] = convertToFieldState(gc);
}

bool Board::hasWin(GameColor gc) const
{
   const auto state = convertToFieldState(gc);

   if (mFields[0][0] == state && mFields[0][1] == state && mFields[0][2] == state) return true;
   if (mFields[1][0] == state && mFields[1][1] == state && mFields[1][2] == state) return true;
   if (mFields[2][0] == state && mFields[2][1] == state && mFields[2][2] == state) return true;

   if (mFields[0][0] == state && mFields[1][0] == state && mFields[2][0] == state) return true;
   if (mFields[0][1] == state && mFields[1][1] == state && mFields[2][1] == state) return true;
   if (mFields[0][2] == state && mFields[1][2] == state && mFields[2][2] == state) return true;

   if (mFields[0][0] == state && mFields[1][1] == state && mFields[2][2] == state) return true;
   if (mFields[0][2] == state && mFields[1][1] == state && mFields[2][0] == state) return true;

   return false;
}


bool Board::isFull() const
{
   for (const auto& row : mFields)
   {
      for (const auto& field : row)
      {
         if (field == FieldState::Empty) return false;
      }
   }
   return true;
}