//=============================================================================

#include <filesystem>
#include <iostream>
#include <optional>
#include <string>
#include <unordered_map>
#include <tuple>
using namespace std;
namespace fs = std::filesystem;

//-----------------------------------------------------------------------------

using extension_t = tuple<uintmax_t, uintmax_t>;       // Anzahl Dateien, Gesamtgroesse
using extinfo_t = unordered_map<string, extension_t>;

//-----------------------------------------------------------------------------

string getFileExtension(const fs::path& filepath)
{
   string ext = filepath.extension().string();
   if (!ext.empty() && ext[0] == '.')
   {
      ext.erase(0, 1); // Remove leading dot
   }
   return ext;
}

//-----------------------------------------------------------------------------

void calculateSizeForAllFileExtensions(const string& dir, extinfo_t& extinfos)
{
   for (const auto& entry : fs::recursive_directory_iterator(dir))
   {
      if (entry.is_regular_file())
      {
         string ext = getFileExtension(entry.path());
         auto& extinfo = extinfos[ext];
         ++get<0>(extinfo); // Increment file count
         get<1>(extinfo) += entry.file_size(); // Add file size
      }
   }
}

//-----------------------------------------------------------------------------

optional<string> askUserForDirectory()
{
   string search_directory;
   cout << "Verzeichnis fuer die Suche eingeben: ";
   getline(cin, search_directory);
   if (!fs::exists(search_directory) || !fs::is_directory(search_directory))
   {
      cout << "Das angegebene Verzeichnis existiert nicht oder ist kein Verzeichnis.\n";
      return {};
   }
   return search_directory;
}

//-----------------------------------------------------------------------------

void printResult(const extinfo_t& extinfos)
{
   cout << "Gefundene Extensions: " << extinfos.size() << '\n';
   for (const auto& [ext, extinfo] : extinfos)
   {
      auto [file_count, total_size] = extinfo;
      cout << "Extension: ." << ext
           << " | Anzahl Dateien: " << file_count
         << " | Gesamtgroesse: " << total_size << " Bytes\n";
   }
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Uebung 06 - Plattenplatz 2 (alle Extension) - Rekursion aus Filesystem\n\n";

   optional<string> opt = askUserForDirectory();
   if (!opt) return 0;
   string search_directory = *opt;

   extinfo_t extinfos;
   calculateSizeForAllFileExtensions(search_directory, extinfos);

   printResult(extinfos);
}
