//=============================================================================

#include <filesystem>
#include <iostream>
#include <optional>
#include <string>
#include <tuple>
using namespace std;
namespace fs = std::filesystem;

//-----------------------------------------------------------------------------

using result_t = tuple<uintmax_t, uintmax_t>;       // Anzahl Dateien, Gesamtgroesse

//-----------------------------------------------------------------------------

result_t calculateSizeForFileExtension(const string& dir, const string& extension)
{
   result_t result{ 0, 0 };
   for (const auto& entry : fs::recursive_directory_iterator(dir))
   {
      if (entry.is_regular_file() && entry.path().extension() == "." + extension)
      {
         ++get<0>(result);
         get<1>(result) += entry.file_size();
      }
   }
   return result;
}

//-----------------------------------------------------------------------------

optional<string> askUserForDirectory()
{
   string search_directory;
   cout << "Verzeichnis fuer die Suche eingeben: ";
   getline(cin, search_directory);
   if (!fs::exists(search_directory) || !fs::is_directory(search_directory))
   {
      cout << "Das angegebene Verzeichnis existiert nicht oder ist kein Verzeichnis.\n";
      return {};
   }
   return search_directory;
}

//-----------------------------------------------------------------------------

optional<string> askUserForExtension()
{
   string search_extension;
   cout << "Extension fuer die Suche eingeben: ";
   getline(cin, search_extension);
   if (search_extension.empty())
   {
      cout << "Es wurde keine Extension eingegeben.\n";
      return {};
   }
   return search_extension;
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Uebung 05 - Plattenplatz - Rekursion aus Filesystem\n\n";

   optional<string> opt = askUserForDirectory();
   if (!opt) return 0;
   string search_directory = *opt;

   opt = askUserForExtension();
   if (!opt) return 0;
   string search_extension = *opt;

   auto [count, size] = calculateSizeForFileExtension(search_directory, search_extension);
   cout << "\nGesamtgroesse: " << size << " Bytes\n";
   cout << "Anzahl: " << count << '\n';
}
