//=============================================================================

#include <filesystem>
#include <iostream>
#include <optional>
#include <string>
#include <vector>
using namespace std;
namespace fs = std::filesystem;

//-----------------------------------------------------------------------------

void search_file_recursively(const string& dir, const string& name, vector<string>& results)
{
   for (const auto& entry : fs::directory_iterator(dir))
   {
      if (entry.is_directory())
      {
         search_file_recursively(entry.path().string(), name, results);
      }
      else if (entry.is_regular_file() && entry.path().filename() == name)
      {
         results.push_back(entry.path().string());
      }
   }
}

//-----------------------------------------------------------------------------

optional<string> askUserForDirectory()
{
   string search_directory;
   cout << "Verzeichnis fuer die Suche eingeben: ";
   getline(cin, search_directory);
   if (!fs::exists(search_directory) || !fs::is_directory(search_directory))
   {
      cout << "Das angegebene Verzeichnis existiert nicht oder ist kein Verzeichnis.\n";
      return {};
   }
   return search_directory;
}

//-----------------------------------------------------------------------------

optional<string> askUserForFilename()
{
   string search_filename;
   cout << "Dateiname fuer die Suche eingeben: ";
   getline(cin, search_filename);
   if (search_filename.empty())
   {
      cout << "Es wurde kein Dateiname eingegeben.\n";
      return {};
   }
   return search_filename;
}

//-----------------------------------------------------------------------------

void printResult(const vector<string>& results)
{
   cout << "Gefundene Dateien: " << results.size() << '\n';
   for (const auto& file_path : results)
   {
      cout << "=> " << file_path << '\n';
   }
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Uebung 04 - Dateisuche einzelne Datei - Rekursion selber\n\n";

   optional<string> opt = askUserForDirectory();
   if (!opt) return 0;
   string search_directory = *opt;

   opt = askUserForFilename();
   if (!opt) return 0;
   string search_filename = *opt;

   vector<string> results;
   search_file_recursively(search_directory, search_filename, results);

   printResult(results);
}
