//=============================================================================

#include <filesystem>
#include <iostream>
#include <string>
#include <vector>
using namespace std;
namespace fs = std::filesystem;

//-----------------------------------------------------------------------------

vector<string> search_file_recursively(const string& dir, const string& name)
{
   vector<string> found_files;
   for (const auto& entry : fs::directory_iterator(dir))
   {
      if (entry.is_directory())
      {
         auto sub_results = search_file_recursively(entry.path().string(), name);
         found_files.insert(found_files.end(), sub_results.begin(), sub_results.end());
      }
      else if (entry.is_regular_file() && entry.path().filename() == name)
      {
         found_files.push_back(entry.path().string());
      }
   }
   return found_files;
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Uebung 03 - Dateisuche einzelne Datei - Rekursion selber\n\n";

   string search_directory;
   cout << "Verzeichnis fuer die Suche eingeben: ";
   getline(cin, search_directory);
   if (!fs::exists(search_directory) || !fs::is_directory(search_directory))
   {
      cout << "Das angegebene Verzeichnis existiert nicht oder ist kein Verzeichnis.\n";
      return 0;
   }

   string search_filename;
   cout << "Dateiname fuer die Suche eingeben: ";
   getline(cin, search_filename);
   if (search_filename.empty())
   {
      cout << "Es wurde kein Dateiname eingegeben.\n";
      return 0;
   }

   auto results = search_file_recursively(search_directory, search_filename);
   cout << "Gefundene Dateien: " << results.size() << '\n';
   for (const auto& file_path : results)
   {
      cout << "=> " << file_path << '\n';
   }
}
