//=============================================================================

#include <chrono>
#include <iostream>
#include <string_view>
#include <vector>
using namespace std;

//-----------------------------------------------------------------------------

constexpr size_t vsize = 200'000'000;
constexpr size_t step  = 10'000;

constexpr size_t xtimes = 20;

vector<int> v;

//-----------------------------------------------------------------------------

size_t run_forward()
{
   size_t res = 0;
   for (vector<int>::size_type i = 0; i < v.size(); ++i)
   {
      res += v[i];
   }
   return res;
}

//-----------------------------------------------------------------------------

size_t run_backward()
{
   size_t res = 0;
   for (vector<int>::size_type i = v.size(); i>0;)
   {
      res += v[--i];
   }
   return res;
}

//-----------------------------------------------------------------------------

size_t run_steps()
{
   size_t res = 0;
   for (vector<int>::size_type seed = 0; seed < step; ++seed)
   {
      for (vector<int>::size_type i = 0; i < v.size(); i += step)
      {
         vector<int>::size_type idx = i + seed;
         res += v[idx];
      }
   }
   return res;
}

//-----------------------------------------------------------------------------

void measure(string_view msg, auto fct)
{
   cout << "Messe: " << msg << '\n';
   auto start = chrono::high_resolution_clock::now();
   size_t res = 0;
   for (int i = 0; i < xtimes; ++i)
   {
      res += fct();
   }
   auto end = chrono::high_resolution_clock::now();
   auto duration = end - start;
   double d = duration.count() / 1'000'000 / 1000.0;
   cout << "=> " << res << "  =>  " << d << " s\n\n";
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Vektor-Cache-Performance\n\n";

   cout << "Vektor fuellen...\n\n";
   v.reserve(vsize);
   for (int i = 0; i < int(vsize); ++i)
   {
      v.push_back(i);
   }

   cout << "Warm up...\n\n";
   run_forward();
   run_backward();
   run_forward();
   run_backward();

   cout << "Messen...\n\n";
   measure("Vorwaerts  "sv, run_forward);
   measure("Rueckwaerts"sv, run_backward);
   measure("Springend  "sv, run_steps);
}
