//=============================================================================

#include "cinder/gl/gl.h"
#include "Torpedo.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

const Color Torpedo::sColor(1.0f, 0.0f, 0.0f);

//-----------------------------------------------------------------------------
// Update im Konstruktor ist notwendig, damit sich das Feuer direkt etwas
// vom Schiff entfernt. Ansonsten fliegt das Schiff beim vorwaerts bewegen
// immer direkt ins eigene Feuer.

Torpedo::Torpedo(const vec2& location, const vec2& direction)
 : Super(location, direction),
   mLength(0.0f)
{
   update();
}

//-----------------------------------------------------------------------------

bool Torpedo::doUpdate()
{
   if (mLength > sScreenHeigth*0.9f)
   {
      return false;
   }

   const float speed = 17.0f;
   mLocation += mDirection * speed;
   mLength += speed;
   return true;
}

//-----------------------------------------------------------------------------

void Torpedo::Draw(const vec2& location, const Color& color)
{
   gl::color(color);
   drawSolidCircle(location, Radius());
}
