//=============================================================================

#include "cinder/gl/gl.h"
#include "cinder/Rand.h"
#include "Asteroid.h"

using namespace ci;
using namespace gl;
using namespace std;

//-----------------------------------------------------------------------------

static const float sRadius[] = { 12.0f, 24.0f, 36.0f, 48.0f };

static const Color sColor(0.5f, 0.49f, 0.51f);

//-----------------------------------------------------------------------------

static vec2 getStartLocation(Asteroid::Region region)
{
   float dx = 1.0f + randFloat(200.0f);
   float dy = 1.0f + randFloat(200.0f);

   float x,y;
   switch (region)
   {
   case Asteroid::Region::LeftTop:
      x = dx;
      y = dy;
      break;
   case Asteroid::Region::RightTop:
      x = Figure::sScreenWidth - dx;
      y = dy;
      break;
   case Asteroid::Region::LeftBottom:
      x = dx;
      y = Figure::sScreenHeigth - dy;
      break;
   case Asteroid::Region::RightBottom:
      x = Figure::sScreenWidth - dx;
      y = Figure::sScreenHeigth - dy;
      break;
   }
   return vec2(x, y);
}

//-----------------------------------------------------------------------------

static vec2 getStartDirection(Asteroid::Region region)
{
   float dx = randFloat(1.f);
   float dy = randFloat(1.f);

   float x, y;
   switch (region)
   {
   case Asteroid::Region::LeftTop:
      x = dx;
      y = dy;
      break;
   case Asteroid::Region::RightTop:
      x = -dx;
      y = dy;
      break;
   case Asteroid::Region::LeftBottom:
      x = dx;
      y = -dy;
      break;
   case Asteroid::Region::RightBottom:
      x = -dx;
      y = -dy;
      break;
   }
   return vec2(x, y);
}

//-----------------------------------------------------------------------------

Asteroid::Asteroid(Region region, Type type)
 : Super(getStartLocation(region), getStartDirection(region)),
   mType(type), mRadius(sRadius[static_cast<int>(type)]),
   mSpeed(4.0f + randFloat(5.0f))
{
}

//-----------------------------------------------------------------------------

Asteroid::Asteroid(const vec2& location, Type type)
: Super(location, vec2(randFloat(2.0f) - 1.0f, randFloat(2.0f) - 1.0f)),
   mType(type), mRadius(sRadius[static_cast<int>(type)]),
   mSpeed(4.0f + randFloat(5.0f))
{
}

//-----------------------------------------------------------------------------

Asteroid::Points Asteroid::getPoints() const
{
   static Points points[] = { 100, 60, 30, 10 };
   return points[static_cast<int>(mType)];
}

//-----------------------------------------------------------------------------

void Asteroid::hit(vector<AsteroidPtr>& news)
{
   switch (mType)
   {
   case Type::Huge:
      news.push_back(make_shared<Asteroid>(mLocation, Type::Big));
      news.push_back(make_shared<Asteroid>(mLocation, Type::Big));
   case Type::Big:
      news.push_back(make_shared<Asteroid>(mLocation, Type::Medium));
      news.push_back(make_shared<Asteroid>(mLocation, Type::Medium));
      news.push_back(make_shared<Asteroid>(mLocation, Type::Medium));
   case Type::Medium:
      news.push_back(make_shared<Asteroid>(mLocation, Type::Small));
      news.push_back(make_shared<Asteroid>(mLocation, Type::Small));
      news.push_back(make_shared<Asteroid>(mLocation, Type::Small));
      news.push_back(make_shared<Asteroid>(mLocation, Type::Small));
      break;
   case Type::Small:
      break;
   }
}

//-----------------------------------------------------------------------------

bool Asteroid::doUpdate()
{
   mLocation += mDirection * mSpeed;
   return true;
}

//-----------------------------------------------------------------------------

void Asteroid::doDraw(const vec2& location) const
{
   gl::color(sColor);
   drawSolidCircle(location, mRadius);
}
