//=============================================================================

#include "cinder/gl/gl.h"
#include "ExplosionAsteroid.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

ExplosionAsteroid::ExplosionAsteroid(const vec2& location)
 : Super(location, cMaxSize)
{
}

//-----------------------------------------------------------------------------

bool ExplosionAsteroid::doUpdate()
{
   return ++mCounter<cMaxSize;
}

//-----------------------------------------------------------------------------

void ExplosionAsteroid::doDraw(const vec2& location) const
{
   float r = radius();
   gl::color(1.0f, 1.0f-r*0.1f, 0.0f);
   gl::drawSolidCircle(location, r);
}
