//=============================================================================

#ifndef EXPLOSION_H
#define EXPLOSION_H

#include <memory>
#include "cinder/Color.h"
#include "cinder/Vector.h"
#include "Figure.h"

//-----------------------------------------------------------------------------

class Explosion : public Figure
{
   using Super = Figure;

protected:
   explicit Explosion(const ci::vec2& location, int maxsize);

   float radius() const;
   float size() const override { return 2*radius(); }

protected:
   int mCounter;

private:
   const int mMaxSize;
};

using ExplosionPtr = std::shared_ptr<Explosion>;

//-----------------------------------------------------------------------------

#endif
