#include "cinder/app/App.h"
#include "cinder/app/RendererGl.h"
#include "cinder/gl/gl.h"
#include "cinder/gl/Texture.h"
#include "cinder/gl/TextureFont.h"

using namespace ci;
using namespace ci::app;
using namespace gl;
using namespace std;

class Cinder21App : public App {
public:
   void setup();
   void update();
   void draw();

private:
   Font mFont;
   TextureFontRef mTextureFont;
};

void Cinder21App::setup()
{
   mFont = Font("Arial", 32);
   mTextureFont = TextureFont::create(mFont);
}

void Cinder21App::update()
{
}

void Cinder21App::draw()
{
   clear(Color(0.f, 0.f, 0.f)); 
   glDisable(GL_TEXTURE_2D);
   enableAlphaBlending();

   string s("Ein 2D OpenGL Text in Cinder");
   color(Color(0.6f, 0.6f, 1.0f));
   mTextureFont->drawString(s, vec2(10.0f, 30.0f));
}

CINDER_APP(Cinder21App, RendererGl, nullptr)
