//=============================================================================

#ifndef UTILS_H
#define UTILS_H

#include <algorithm>

//-----------------------------------------------------------------------------

template<class TCont, class TOutIt> TOutIt copy_c(const TCont& c, const TOutIt& outit)
{
   return copy(cbegin(c), cend(c), outit);
}

//-----------------------------------------------------------------------------

template<class TCont, class TVal> typename TCont::iterator erase_c(TCont& c, const TVal& val)
{
   auto it = remove(begin(c), end(c), val);
   return c.erase(it, end(c));
}

//-----------------------------------------------------------------------------

template<class TCont, class TOp> typename TCont::iterator erase_if_c(TCont& c, const TOp& op)
{
   auto it = remove_if(begin(c), end(c), op);
   return c.erase(it, end(c));
}

//-----------------------------------------------------------------------------

template<class TContainer, class TOp> TOp for_each_c(const TContainer& c, TOp op)
{
   return std::for_each(cbegin(c), cend(c), op);
}

template<class TContainer, class TOp> TOp for_each_c(TContainer& c, TOp op)
{
   return std::for_each(begin(c), end(c), op);
}

//-----------------------------------------------------------------------------

#endif
