//=============================================================================

#include "cinder/gl/gl.h"
#include "Explosion.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

Explosion::Explosion(const vec2& location, int maxsize)
 : Super(location, vec2(0.f, 0.f)),
   mCounter(0),
   mMaxSize(maxsize)
{
}

//-----------------------------------------------------------------------------

float Explosion::radius() const
{
   float res = static_cast<float>(mCounter);
   if (mCounter>mMaxSize/2)
   {
      res = static_cast<float>(mMaxSize-mCounter);
   }
   return res;
}
