//=============================================================================

#ifndef EXPLOSION_ASTEROID_H
#define EXPLOSION_ASTEROID_H

#include <memory>
#include "cinder/Vector.h"
#include "Figure.h"

//-----------------------------------------------------------------------------

class ExplosionAsteroid : public Figure
{
   using Super = Figure;

public:
   explicit ExplosionAsteroid(const ci::vec2& location);

protected:
   float radius() const;
   float size() const override { return 2*radius(); }

   bool doUpdate() override;
   void doDraw(const ci::vec2& location) const override;

private:
   int mCounter;
};

using ExplosionAsteroidPtr = std::shared_ptr<ExplosionAsteroid>;

//-----------------------------------------------------------------------------

#endif
