//=============================================================================

#ifndef SHIP_H
#define SHIP_H

#include <memory>
#include "cinder/Color.h"
#include "cinder/Vector.h"

//-----------------------------------------------------------------------------

class Ship
{
public:
   static float sScreenWidth;
   static float sScreenHeigth;

   explicit Ship();

   void rotate(float degree);
   void accelerate(float accel);

   void update();
   void draw() const;

   static void Draw(const ci::vec2& location, const ci::vec2& direction, const ci::Color& color);

   static float Radius() { return 8.0f; }
   static float Size() { return 2*Radius(); }

private:
   static const ci::Color sColor;
   ci::vec2 mLocation;
   ci::vec2 mDirection;
   float mSpeed;
};

using ShipPtr = std::shared_ptr<Ship>;

//-----------------------------------------------------------------------------

#endif
