//=============================================================================

#include "cinder/app/App.h"
#include "cinder/app/RendererGl.h"
#include "cinder/Color.h"
#include "cinder/gl/gl.h"
#include "cinder/Vector.h"
#include "Ship.h"

using namespace ci;
using namespace ci::app;
using namespace gl;
using namespace std;

//-----------------------------------------------------------------------------

class CinderApp : public App
{
public:
   static void prepareSettings(Settings* settings);
   void setup() override;
   void update() override;
   void draw() override;

   void keyDown(KeyEvent event) override;
   void keyUp(KeyEvent event) override;

private:
   bool mKeyRight=false, mKeyLeft=false;

   ShipPtr mShip;
};

//-----------------------------------------------------------------------------

void CinderApp::prepareSettings(Settings* settings)
{
   settings->setTitle("Cinder 06 - Raumschiff rotieren");
   settings->setResizable(false);
   settings->setWindowPos(1000, 300);
   settings->setWindowSize(640, 480);
   settings->setFrameRate(30.0f);
}

//-----------------------------------------------------------------------------

void CinderApp::setup()
{
   Ship::sScreenWidth = static_cast<float>(getWindowWidth());
   Ship::sScreenHeigth = static_cast<float>(getWindowHeight());

   mShip = make_shared<Ship>();
}

//-----------------------------------------------------------------------------

void CinderApp::update()
{
   if (mKeyRight && mShip)
   {
      mShip->rotate(+9.f);
   }
   if (mKeyLeft && mShip)
   {
      mShip->rotate(-9.f);
   }
}

//-----------------------------------------------------------------------------

void CinderApp::draw()
{
   clear(Color(0, 0, 0));

   if (mShip)
   {
      mShip->draw();
   }
}

//-----------------------------------------------------------------------------

void CinderApp::keyDown(KeyEvent event)
{
   switch (event.getCode())
   {
   case KeyEvent::KEY_RIGHT:
      mKeyRight = true;
      break;
   case KeyEvent::KEY_LEFT:
      mKeyLeft = true;
      break;
   }
}

//-----------------------------------------------------------------------------

void CinderApp::keyUp(KeyEvent event)
{
   switch (event.getCode())
   {
   case KeyEvent::KEY_RIGHT:
      mKeyRight = false;
      break;
   case KeyEvent::KEY_LEFT:
      mKeyLeft = false;
      break;
   }
}

//-----------------------------------------------------------------------------

CINDER_APP(CinderApp, RendererGl(), &CinderApp::prepareSettings)
